inputfolder = './';
xmlpath = './locations.xml';

xDoc = xmlread(xmlpath);
allImages = xDoc.getElementsByTagName('IMG');

for k = 0:allImages.getLength-1

    thisItem = allImages.item(k);
    imgname = thisItem.getAttributes.item(1).getValue; 
    imgname = char(imgname); 
    bw = imread(imgname); bw = false(size(bw,1), size(bw,2));
    
    childNode = thisItem.getFirstChild;  
    rgns = cell(1, 0); cnt_rgns = 0;
    
    while ~isempty(childNode)
        
      if childNode.getNodeType == childNode.ELEMENT_NODE
          
         nodename = char(childNode.getNodeName);
         
         if isequal(nodename, 'AnnotateRgn') 
             posNode = childNode.getFirstChild;
             t = 0; pts = [];
             while ~isempty(posNode)
                 if posNode.getNodeType == posNode.ELEMENT_NODE
                     if isequal(char(posNode.getNodeName), 'AnnotatePoint')
                         x = str2num(posNode.getAttributes.item(0).getValue); 
                         y = str2num(posNode.getAttributes.item(1).getValue); 
                         pts = [pts; y, x];
                     end
                end
                 posNode = posNode.getNextSibling;
             end
             
             cnt_rgns = cnt_rgns + 1;
             rgns{1, cnt_rgns} = pts;
             
         end
         
      end
          
      childNode = childNode.getNextSibling;
    end 

    for kk = 1:length(rgns)
        pts = rgns{1, kk}; pts = [pts; pts(1,:)];
        bw0 = poly2mask(pts(:,2), pts(:,1), size(bw,1), size(bw,2));
        bw = bw | bw0;
    end

    imgname = imgname(1:length(imgname)-4);
    imwrite(bw, ['./maps/', imgname, '.bmp']);
end

